/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Content {
    public static BufferedImage[] Comet = Content.load("/Sprites/Enemies/Comet.png", 64, 64, 30);
    public static BufferedImage[] CometDestroyed = Content.load("/Sprites/Enemies/Comet_Destroyed.png", 64, 64, 5);
    public static BufferedImage[][] Invader = Content.load("/Sprites/Enemies/enemy_spaceship.png", 32, 32);
    public static BufferedImage InvaderBullet = Content.load("/Sprites/Enemies/Invader_Bullet.png", 11, 5, 0, 0);
    public static BufferedImage BlackHole = Content.load("/Sprites/Enemies/blackhole.png", 62, 64, 0, 0);
    public static BufferedImage Bullet = Content.load("/Sprites/Player/bullet.png", 10, 5, 0, 0);
    public static BufferedImage TripleBullet = Content.enlarge(Content.load("/Sprites/Player/TripleShot.png", 11, 11, 0, 0), 2);
    public static BufferedImage[] Shield = Content.load("/Sprites/Player/shield.png", 72, 66, 8);
    public static BufferedImage[] Beam = Content.load("/Sprites/Player/Beam.png", 800, 76, 2);
    public static BufferedImage[] MissileLaunch = Content.load("/Sprites/Player/Missile_Launch.png", 34, 16, 5);
    public static BufferedImage[] MissileIgnited = Content.load("/Sprites/Player/Missile_Ignited.png", 34, 16, 2);
    public static BufferedImage[] MissileExplosion = Content.load("/Sprites/Enemies/ExplosionSpritesheet.png", 256, 256, 48);
    public static BufferedImage[] ShipExplosion = Content.load("/Sprites/Player/Death.png", 110, 102, 12);
    public static BufferedImage BluePowerUp = Content.enlarge(Content.load("/Sprites/Other/BluePowerUp.png", 8, 10, 0, 0), 2);
    public static BufferedImage RedPowerUp = Content.enlarge(Content.load("/Sprites/Other/RedPowerUp.png", 8, 10, 0, 0), 2);
    public static BufferedImage GreenPowerUp = Content.enlarge(Content.load("/Sprites/Other/GreenPowerUp.png", 8, 10, 0, 0), 2);
    public static BufferedImage PurplePowerUp = Content.enlarge(Content.load("/Sprites/Other/PurplePowerUp.png", 8, 10, 0, 0), 2);
    public static BufferedImage Life = Content.load("/Sprites/Player/Life.png", 20, 18, 0, 0);
    public static BufferedImage PauseBG = Content.load("/Backgrounds/Pause_60.png", 800, 400, 0, 0);
    public static BufferedImage MenuBG = Content.load("/Backgrounds/Menu_BG.png", 800, 400, 0, 0);
    public static BufferedImage FrontMenuBG = Content.load("/Backgrounds/FrontMenuBG.gif", 800, 400, 0, 0);
    public static BufferedImage HowToControls = Content.load("/HUD/Controls.png", 800, 400, 0, 0);
    public static BufferedImage HowToCollectables = Content.load("/HUD/Collectables.png", 800, 400, 0, 0);
    public static BufferedImage HowToObjectives = Content.load("/HUD/Objectives.png", 800, 400, 0, 0);
    public static BufferedImage CometDefender = Content.load("/HUD/CometDefenderLogo.png", 800, 400, 0, 0);
    public static BufferedImage SpaceshipIntro = Content.enlarge(Content.load("/HUD/Spaceship_Introshot.png", 217, 192, 0, 0), 2);
    public static BufferedImage[][] Mouse = Content.load("/HUD/MouseCursor.png", 30, 24);

    public static BufferedImage[][] load(String s, int w, int h) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[][] ret = new BufferedImage[height][width];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[i][j] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage[][] load(BufferedImage spritesheet, int w, int h) {
        try {
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[][] ret = new BufferedImage[height][width];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[i][j] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage[] load(String s, int w, int h, int numFrames) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[] ret = new BufferedImage[numFrames];
            int k = 0;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[k] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++k;
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage load(String s, int w, int h, int x, int y) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            BufferedImage ret = spritesheet.getSubimage(x, y, w, h);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage enlarge(BufferedImage image, int n) {
        int w = n * image.getWidth();
        int h = n * image.getHeight();
        BufferedImage enlargedImage = new BufferedImage(w, h, image.getType());
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                enlargedImage.setRGB(x, y, image.getRGB(x / n, y / n));
                ++x;
            }
            ++y;
        }
        return enlargedImage;
    }
}

